#include <bits/stdc++.h> 
using namespace std;

bool valid_index(int index, int n) {
    return index>=0 && index<n;
}
char res[(int)1e6];
int operations = 0;
int killed = 0;
int closestNorth;
int closestSouth;
int lastOperation = -1;
int curPos = 0;


void killNorth() {
    killed++;
    closestNorth++;
    lastOperation = 1;
}

void killSouth() {
    killed++;
    closestSouth--;
    lastOperation = 2;
}

void move() {
    curPos++;
    lastOperation = 3;
}


int main() {
    ios_base::sync_with_stdio(false);
    int n;
    cin>>n;
    vector<int> a(n);
    for (int i = 0; i<n; i++) {
        cin>>a[i];
    }

    sort(a.begin(), a.end());
    
    closestNorth = lower_bound(a.begin(), a.end(), 0) - a.begin();
    closestSouth = closestNorth - 1;

    while (operations < 1e6 && (valid_index(closestNorth, n) || valid_index(closestSouth, n))) {
        int distanceNorth = (valid_index(closestNorth, n)) ? a[closestNorth] - curPos - operations : numeric_limits<int>::max();
        int distanceSouth = (valid_index(closestSouth, n)) ? curPos - a[closestSouth] + operations : numeric_limits<int>::max();

        if (distanceSouth == 0 || distanceNorth == 0) break;

        if (lastOperation == 1) {
            killSouth();

        }


        else if (lastOperation == 2) {
            if (distanceNorth < distanceSouth) {
                killNorth();
            }
            else {
                move();
            }
        }

        else {
            if (distanceNorth < distanceSouth) {
                killNorth();
            }

            else {
                killSouth();
            }
        }

        res[operations++] = lastOperation;
    }


    cout<<killed<<'\n';

    for (int i = 0; i<operations; i++) {
        cout<<(int)res[i];
    }

}